package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteInvitationsResponse(
    unprocessedAccounts: Option[
      Iterable[zio.aws.macie2.model.UnprocessedAccount]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse = {
    import DeleteInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly =
    zio.aws.macie2.model.DeleteInvitationsResponse.wrap(buildAwsValue())
}
object DeleteInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DeleteInvitationsResponse =
      zio.aws.macie2.model.DeleteInvitationsResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Option[List[zio.aws.macie2.model.UnprocessedAccount.ReadOnly]]
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse
  ) extends zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly {
    override val unprocessedAccounts
        : Option[List[zio.aws.macie2.model.UnprocessedAccount.ReadOnly]] = scala
      .Option(impl.unprocessedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.UnprocessedAccount.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse
  ): zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly = new Wrapper(impl)
}
