package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteInvitationsRequest(accountIds: Iterable[__string]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest = {
    import DeleteInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DeleteInvitationsRequest.ReadOnly =
    zio.aws.macie2.model.DeleteInvitationsRequest.wrap(buildAwsValue())
}
object DeleteInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DeleteInvitationsRequest =
      zio.aws.macie2.model.DeleteInvitationsRequest(accountIds)
    def accountIds: List[__string]
    def getAccountIds: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest
  ) extends zio.aws.macie2.model.DeleteInvitationsRequest.ReadOnly {
    override val accountIds: List[__string] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.macie2.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest
  ): zio.aws.macie2.model.DeleteInvitationsRequest.ReadOnly = new Wrapper(impl)
}
