package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters.*
final case class CustomDataIdentifiers(
    detections: Option[Iterable[zio.aws.macie2.model.CustomDetection]] = None,
    totalCount: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers = {
    import CustomDataIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
      .builder()
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(
        totalCount.map(value => __long.unwrap(value): java.lang.Long)
      )(_.totalCount)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly =
    zio.aws.macie2.model.CustomDataIdentifiers.wrap(buildAwsValue())
}
object CustomDataIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CustomDataIdentifiers =
      zio.aws.macie2.model.CustomDataIdentifiers(
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def detections: Option[List[zio.aws.macie2.model.CustomDetection.ReadOnly]]
    def totalCount: Option[__long]
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.CustomDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
  ) extends zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly {
    override val detections
        : Option[List[zio.aws.macie2.model.CustomDetection.ReadOnly]] = scala
      .Option(impl.detections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.CustomDetection.wrap(item)
        }.toList
      )
    override val totalCount: Option[__long] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
  ): zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly = new Wrapper(impl)
}
