package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CustomDataIdentifierSummary(
    arn: Option[__string] = None,
    createdAt: Option[__timestampIso8601] = None,
    description: Option[__string] = None,
    id: Option[__string] = None,
    name: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary = {
    import CustomDataIdentifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly =
    zio.aws.macie2.model.CustomDataIdentifierSummary.wrap(buildAwsValue())
}
object CustomDataIdentifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CustomDataIdentifierSummary =
      zio.aws.macie2.model.CustomDataIdentifierSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def arn: Option[__string]
    def createdAt: Option[__timestampIso8601]
    def description: Option[__string]
    def id: Option[__string]
    def name: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
  ) extends zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val createdAt: Option[__timestampIso8601] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
  ): zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly = new Wrapper(
    impl
  )
}
