package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class CreateFindingsFilterRequest(
    action: zio.aws.macie2.model.FindingsFilterAction,
    clientToken: Option[__string] = None,
    description: Option[__string] = None,
    findingCriteria: zio.aws.macie2.model.FindingCriteria,
    name: __string,
    position: Option[__integer] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest = {
    import CreateFindingsFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
      .builder()
      .action(action.unwrap)
      .optionallyWith(
        clientToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .findingCriteria(findingCriteria.buildAwsValue())
      .name(__string.unwrap(name): java.lang.String)
      .optionallyWith(position.map(value => __integer.unwrap(value): Integer))(
        _.position
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateFindingsFilterRequest.ReadOnly =
    zio.aws.macie2.model.CreateFindingsFilterRequest.wrap(buildAwsValue())
}
object CreateFindingsFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateFindingsFilterRequest =
      zio.aws.macie2.model.CreateFindingsFilterRequest(
        action,
        clientToken.map(value => value),
        description.map(value => value),
        findingCriteria.asEditable,
        name,
        position.map(value => value),
        tags.map(value => value)
      )
    def action: zio.aws.macie2.model.FindingsFilterAction
    def clientToken: Option[__string]
    def description: Option[__string]
    def findingCriteria: zio.aws.macie2.model.FindingCriteria.ReadOnly
    def name: __string
    def position: Option[__integer]
    def tags: Option[Map[__string, __string]]
    def getAction
        : ZIO[Any, Nothing, zio.aws.macie2.model.FindingsFilterAction] =
      ZIO.succeed(action)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getFindingCriteria
        : ZIO[Any, Nothing, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      ZIO.succeed(findingCriteria)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getPosition: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("position", position)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
  ) extends zio.aws.macie2.model.CreateFindingsFilterRequest.ReadOnly {
    override val action: zio.aws.macie2.model.FindingsFilterAction =
      zio.aws.macie2.model.FindingsFilterAction.wrap(impl.action())
    override val clientToken: Option[__string] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val findingCriteria
        : zio.aws.macie2.model.FindingCriteria.ReadOnly =
      zio.aws.macie2.model.FindingCriteria.wrap(impl.findingCriteria())
    override val name: __string =
      zio.aws.macie2.model.primitives.__string(impl.name())
    override val position: Option[__integer] = scala
      .Option(impl.position())
      .map(value => zio.aws.macie2.model.primitives.__integer(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives
              .__string(key) -> zio.aws.macie2.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest
  ): zio.aws.macie2.model.CreateFindingsFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
