package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ClassificationDetails(
    detailedResultsLocation: Option[__string] = None,
    jobArn: Option[__string] = None,
    jobId: Option[__string] = None,
    result: Option[zio.aws.macie2.model.ClassificationResult] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationDetails = {
    import ClassificationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationDetails
      .builder()
      .optionallyWith(
        detailedResultsLocation.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.detailedResultsLocation)
      .optionallyWith(
        jobArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(result.map(value => value.buildAwsValue()))(_.result)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ClassificationDetails.ReadOnly =
    zio.aws.macie2.model.ClassificationDetails.wrap(buildAwsValue())
}
object ClassificationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationDetails =
      zio.aws.macie2.model.ClassificationDetails(
        detailedResultsLocation.map(value => value),
        jobArn.map(value => value),
        jobId.map(value => value),
        result.map(value => value.asEditable)
      )
    def detailedResultsLocation: Option[__string]
    def jobArn: Option[__string]
    def jobId: Option[__string]
    def result: Option[zio.aws.macie2.model.ClassificationResult.ReadOnly]
    def getDetailedResultsLocation: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("detailedResultsLocation", detailedResultsLocation)
    def getJobArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getResult: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationResult.ReadOnly
    ] = AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationDetails
  ) extends zio.aws.macie2.model.ClassificationDetails.ReadOnly {
    override val detailedResultsLocation: Option[__string] = scala
      .Option(impl.detailedResultsLocation())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val jobArn: Option[__string] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val jobId: Option[__string] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val result
        : Option[zio.aws.macie2.model.ClassificationResult.ReadOnly] = scala
      .Option(impl.result())
      .map(value => zio.aws.macie2.model.ClassificationResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationDetails
  ): zio.aws.macie2.model.ClassificationDetails.ReadOnly = new Wrapper(impl)
}
