package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class Cell(
    cellReference: Option[__string] = None,
    column: Option[__long] = None,
    columnName: Option[__string] = None,
    row: Option[__long] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Cell = {
    import Cell.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Cell
      .builder()
      .optionallyWith(
        cellReference.map(value => __string.unwrap(value): java.lang.String)
      )(_.cellReference)
      .optionallyWith(
        column.map(value => __long.unwrap(value): java.lang.Long)
      )(_.column)
      .optionallyWith(
        columnName.map(value => __string.unwrap(value): java.lang.String)
      )(_.columnName)
      .optionallyWith(row.map(value => __long.unwrap(value): java.lang.Long))(
        _.row
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Cell.ReadOnly =
    zio.aws.macie2.model.Cell.wrap(buildAwsValue())
}
object Cell {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Cell] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Cell = zio.aws.macie2.model.Cell(
      cellReference.map(value => value),
      column.map(value => value),
      columnName.map(value => value),
      row.map(value => value)
    )
    def cellReference: Option[__string]
    def column: Option[__long]
    def columnName: Option[__string]
    def row: Option[__long]
    def getCellReference: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("cellReference", cellReference)
    def getColumn: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("column", column)
    def getColumnName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("columnName", columnName)
    def getRow: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("row", row)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Cell
  ) extends zio.aws.macie2.model.Cell.ReadOnly {
    override val cellReference: Option[__string] = scala
      .Option(impl.cellReference())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val column: Option[__long] = scala
      .Option(impl.column())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val columnName: Option[__string] = scala
      .Option(impl.columnName())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val row: Option[__long] = scala
      .Option(impl.row())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Cell
  ): zio.aws.macie2.model.Cell.ReadOnly = new Wrapper(impl)
}
