package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateFindingsFilterResponse(
    arn: Option[__string] = None,
    id: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse = {
    import UpdateFindingsFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly =
    zio.aws.macie2.model.UpdateFindingsFilterResponse.wrap(buildAwsValue())
}
object UpdateFindingsFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateFindingsFilterResponse =
      zio.aws.macie2.model.UpdateFindingsFilterResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Option[__string]
    def id: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse
  ) extends zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse
  ): zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly = new Wrapper(
    impl
  )
}
