package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TagCriterionPairForJob(
    key: Option[__string] = None,
    value: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob = {
    import TagCriterionPairForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
      .builder()
      .optionallyWith(
        key.map(value => __string.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => __string.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly =
    zio.aws.macie2.model.TagCriterionPairForJob.wrap(buildAwsValue())
}
object TagCriterionPairForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TagCriterionPairForJob =
      zio.aws.macie2.model.TagCriterionPairForJob(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Option[__string]
    def value: Option[__string]
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
  ) extends zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly {
    override val key: Option[__string] = scala
      .Option(impl.key())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val value: Option[__string] = scala
      .Option(impl.value())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob
  ): zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly = new Wrapper(impl)
}
