package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SimpleCriterionForJob(
    comparator: Option[zio.aws.macie2.model.JobComparator] = None,
    key: Option[zio.aws.macie2.model.SimpleCriterionKeyForJob] = None,
    values: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SimpleCriterionForJob = {
    import SimpleCriterionForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SimpleCriterionForJob
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly =
    zio.aws.macie2.model.SimpleCriterionForJob.wrap(buildAwsValue())
}
object SimpleCriterionForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SimpleCriterionForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SimpleCriterionForJob =
      zio.aws.macie2.model.SimpleCriterionForJob(
        comparator.map(value => value),
        key.map(value => value),
        values.map(value => value)
      )
    def comparator: Option[zio.aws.macie2.model.JobComparator]
    def key: Option[zio.aws.macie2.model.SimpleCriterionKeyForJob]
    def values: Option[List[__string]]
    def getComparator: ZIO[Any, AwsError, zio.aws.macie2.model.JobComparator] =
      AwsError.unwrapOptionField("comparator", comparator)
    def getKey
        : ZIO[Any, AwsError, zio.aws.macie2.model.SimpleCriterionKeyForJob] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SimpleCriterionForJob
  ) extends zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly {
    override val comparator: Option[zio.aws.macie2.model.JobComparator] = scala
      .Option(impl.comparator())
      .map(value => zio.aws.macie2.model.JobComparator.wrap(value))
    override val key: Option[zio.aws.macie2.model.SimpleCriterionKeyForJob] =
      scala
        .Option(impl.key())
        .map(value => zio.aws.macie2.model.SimpleCriterionKeyForJob.wrap(value))
    override val values: Option[List[__string]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SimpleCriterionForJob
  ): zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly = new Wrapper(impl)
}
