package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__boolean, __timestampIso8601}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SessionContextAttributes(
    creationDate: Option[__timestampIso8601] = None,
    mfaAuthenticated: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SessionContextAttributes = {
    import SessionContextAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SessionContextAttributes
      .builder()
      .optionallyWith(
        creationDate.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        mfaAuthenticated.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.mfaAuthenticated)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SessionContextAttributes.ReadOnly =
    zio.aws.macie2.model.SessionContextAttributes.wrap(buildAwsValue())
}
object SessionContextAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SessionContextAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SessionContextAttributes =
      zio.aws.macie2.model.SessionContextAttributes(
        creationDate.map(value => value),
        mfaAuthenticated.map(value => value)
      )
    def creationDate: Option[__timestampIso8601]
    def mfaAuthenticated: Option[__boolean]
    def getCreationDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getMfaAuthenticated: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("mfaAuthenticated", mfaAuthenticated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SessionContextAttributes
  ) extends zio.aws.macie2.model.SessionContextAttributes.ReadOnly {
    override val creationDate: Option[__timestampIso8601] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val mfaAuthenticated: Option[__boolean] = scala
      .Option(impl.mfaAuthenticated())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SessionContextAttributes
  ): zio.aws.macie2.model.SessionContextAttributes.ReadOnly = new Wrapper(impl)
}
