package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __boolean}
import scala.jdk.CollectionConverters.*
final case class ServiceLimit(
    isServiceLimited: Option[__boolean] = None,
    unit: Option[zio.aws.macie2.model.Unit] = None,
    value: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ServiceLimit = {
    import ServiceLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ServiceLimit
      .builder()
      .optionallyWith(
        isServiceLimited.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.isServiceLimited)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(value.map(value => __long.unwrap(value): java.lang.Long))(
        _.value
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ServiceLimit.ReadOnly =
    zio.aws.macie2.model.ServiceLimit.wrap(buildAwsValue())
}
object ServiceLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ServiceLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ServiceLimit =
      zio.aws.macie2.model.ServiceLimit(
        isServiceLimited.map(value => value),
        unit.map(value => value),
        value.map(value => value)
      )
    def isServiceLimited: Option[__boolean]
    def unit: Option[zio.aws.macie2.model.Unit]
    def value: Option[__long]
    def getIsServiceLimited: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isServiceLimited", isServiceLimited)
    def getUnit: ZIO[Any, AwsError, zio.aws.macie2.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ServiceLimit
  ) extends zio.aws.macie2.model.ServiceLimit.ReadOnly {
    override val isServiceLimited: Option[__boolean] = scala
      .Option(impl.isServiceLimited())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val unit: Option[zio.aws.macie2.model.Unit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.macie2.model.Unit.wrap(value))
    override val value: Option[__long] = scala
      .Option(impl.value())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ServiceLimit
  ): zio.aws.macie2.model.ServiceLimit.ReadOnly = new Wrapper(impl)
}
