package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class S3Bucket(
    allowsUnencryptedObjectUploads: Option[
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = None,
    arn: Option[__string] = None,
    createdAt: Option[__timestampIso8601] = None,
    defaultServerSideEncryption: Option[
      zio.aws.macie2.model.ServerSideEncryption
    ] = None,
    name: Option[__string] = None,
    owner: Option[zio.aws.macie2.model.S3BucketOwner] = None,
    publicAccess: Option[zio.aws.macie2.model.BucketPublicAccess] = None,
    tags: Option[Iterable[zio.aws.macie2.model.KeyValuePair]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.S3Bucket = {
    import S3Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3Bucket
      .builder()
      .optionallyWith(
        allowsUnencryptedObjectUploads.map(value => value.unwrap)
      )(_.allowsUnencryptedObjectUploads)
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        defaultServerSideEncryption.map(value => value.buildAwsValue())
      )(_.defaultServerSideEncryption)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(publicAccess.map(value => value.buildAwsValue()))(
        _.publicAccess
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3Bucket.ReadOnly =
    zio.aws.macie2.model.S3Bucket.wrap(buildAwsValue())
}
object S3Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.S3Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3Bucket =
      zio.aws.macie2.model.S3Bucket(
        allowsUnencryptedObjectUploads.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        defaultServerSideEncryption.map(value => value.asEditable),
        name.map(value => value),
        owner.map(value => value.asEditable),
        publicAccess.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allowsUnencryptedObjectUploads
        : Option[zio.aws.macie2.model.AllowsUnencryptedObjectUploads]
    def arn: Option[__string]
    def createdAt: Option[__timestampIso8601]
    def defaultServerSideEncryption
        : Option[zio.aws.macie2.model.ServerSideEncryption.ReadOnly]
    def name: Option[__string]
    def owner: Option[zio.aws.macie2.model.S3BucketOwner.ReadOnly]
    def publicAccess: Option[zio.aws.macie2.model.BucketPublicAccess.ReadOnly]
    def tags: Option[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]]
    def getAllowsUnencryptedObjectUploads: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = AwsError.unwrapOptionField(
      "allowsUnencryptedObjectUploads",
      allowsUnencryptedObjectUploads
    )
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDefaultServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultServerSideEncryption",
      defaultServerSideEncryption
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3BucketOwner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3Bucket
  ) extends zio.aws.macie2.model.S3Bucket.ReadOnly {
    override val allowsUnencryptedObjectUploads
        : Option[zio.aws.macie2.model.AllowsUnencryptedObjectUploads] = scala
      .Option(impl.allowsUnencryptedObjectUploads())
      .map(value =>
        zio.aws.macie2.model.AllowsUnencryptedObjectUploads.wrap(value)
      )
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val createdAt: Option[__timestampIso8601] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val defaultServerSideEncryption
        : Option[zio.aws.macie2.model.ServerSideEncryption.ReadOnly] = scala
      .Option(impl.defaultServerSideEncryption())
      .map(value => zio.aws.macie2.model.ServerSideEncryption.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val owner: Option[zio.aws.macie2.model.S3BucketOwner.ReadOnly] =
      scala
        .Option(impl.owner())
        .map(value => zio.aws.macie2.model.S3BucketOwner.wrap(value))
    override val publicAccess
        : Option[zio.aws.macie2.model.BucketPublicAccess.ReadOnly] = scala
      .Option(impl.publicAccess())
      .map(value => zio.aws.macie2.model.BucketPublicAccess.wrap(value))
    override val tags
        : Option[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.KeyValuePair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3Bucket
  ): zio.aws.macie2.model.S3Bucket.ReadOnly = new Wrapper(impl)
}
