package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class ReplicationDetails(
    replicated: Option[__boolean] = None,
    replicatedExternally: Option[__boolean] = None,
    replicationAccounts: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ReplicationDetails = {
    import ReplicationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ReplicationDetails
      .builder()
      .optionallyWith(
        replicated.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.replicated)
      .optionallyWith(
        replicatedExternally.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.replicatedExternally)
      .optionallyWith(
        replicationAccounts.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replicationAccounts)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ReplicationDetails.ReadOnly =
    zio.aws.macie2.model.ReplicationDetails.wrap(buildAwsValue())
}
object ReplicationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ReplicationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ReplicationDetails =
      zio.aws.macie2.model.ReplicationDetails(
        replicated.map(value => value),
        replicatedExternally.map(value => value),
        replicationAccounts.map(value => value)
      )
    def replicated: Option[__boolean]
    def replicatedExternally: Option[__boolean]
    def replicationAccounts: Option[List[__string]]
    def getReplicated: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("replicated", replicated)
    def getReplicatedExternally: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("replicatedExternally", replicatedExternally)
    def getReplicationAccounts: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("replicationAccounts", replicationAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ReplicationDetails
  ) extends zio.aws.macie2.model.ReplicationDetails.ReadOnly {
    override val replicated: Option[__boolean] = scala
      .Option(impl.replicated())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val replicatedExternally: Option[__boolean] = scala
      .Option(impl.replicatedExternally())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val replicationAccounts: Option[List[__string]] = scala
      .Option(impl.replicationAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ReplicationDetails
  ): zio.aws.macie2.model.ReplicationDetails.ReadOnly = new Wrapper(impl)
}
