package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Occurrences(
    cells: Option[Iterable[zio.aws.macie2.model.Cell]] = None,
    lineRanges: Option[Iterable[zio.aws.macie2.model.Range]] = None,
    offsetRanges: Option[Iterable[zio.aws.macie2.model.Range]] = None,
    pages: Option[Iterable[zio.aws.macie2.model.Page]] = None,
    records: Option[Iterable[zio.aws.macie2.model.Record]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.Occurrences = {
    import Occurrences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Occurrences
      .builder()
      .optionallyWith(
        cells.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cells)
      .optionallyWith(
        lineRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineRanges)
      .optionallyWith(
        offsetRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offsetRanges)
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pages)
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Occurrences.ReadOnly =
    zio.aws.macie2.model.Occurrences.wrap(buildAwsValue())
}
object Occurrences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.Occurrences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Occurrences =
      zio.aws.macie2.model.Occurrences(
        cells.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lineRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        offsetRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cells: Option[List[zio.aws.macie2.model.Cell.ReadOnly]]
    def lineRanges: Option[List[zio.aws.macie2.model.Range.ReadOnly]]
    def offsetRanges: Option[List[zio.aws.macie2.model.Range.ReadOnly]]
    def pages: Option[List[zio.aws.macie2.model.Page.ReadOnly]]
    def records: Option[List[zio.aws.macie2.model.Record.ReadOnly]]
    def getCells: ZIO[Any, AwsError, List[zio.aws.macie2.model.Cell.ReadOnly]] =
      AwsError.unwrapOptionField("cells", cells)
    def getLineRanges
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("lineRanges", lineRanges)
    def getOffsetRanges
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("offsetRanges", offsetRanges)
    def getPages: ZIO[Any, AwsError, List[zio.aws.macie2.model.Page.ReadOnly]] =
      AwsError.unwrapOptionField("pages", pages)
    def getRecords
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Record.ReadOnly]] =
      AwsError.unwrapOptionField("records", records)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Occurrences
  ) extends zio.aws.macie2.model.Occurrences.ReadOnly {
    override val cells: Option[List[zio.aws.macie2.model.Cell.ReadOnly]] = scala
      .Option(impl.cells())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.Cell.wrap(item)
        }.toList
      )
    override val lineRanges: Option[List[zio.aws.macie2.model.Range.ReadOnly]] =
      scala
        .Option(impl.lineRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.Range.wrap(item)
          }.toList
        )
    override val offsetRanges
        : Option[List[zio.aws.macie2.model.Range.ReadOnly]] = scala
      .Option(impl.offsetRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.Range.wrap(item)
        }.toList
      )
    override val pages: Option[List[zio.aws.macie2.model.Page.ReadOnly]] = scala
      .Option(impl.pages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.Page.wrap(item)
        }.toList
      )
    override val records: Option[List[zio.aws.macie2.model.Record.ReadOnly]] =
      scala
        .Option(impl.records())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.Record.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Occurrences
  ): zio.aws.macie2.model.Occurrences.ReadOnly = new Wrapper(impl)
}
