package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters.*
final case class ObjectCountByEncryptionType(
    customerManaged: Option[__long] = None,
    kmsManaged: Option[__long] = None,
    s3Managed: Option[__long] = None,
    unencrypted: Option[__long] = None,
    unknown: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType = {
    import ObjectCountByEncryptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
      .builder()
      .optionallyWith(
        customerManaged.map(value => __long.unwrap(value): java.lang.Long)
      )(_.customerManaged)
      .optionallyWith(
        kmsManaged.map(value => __long.unwrap(value): java.lang.Long)
      )(_.kmsManaged)
      .optionallyWith(
        s3Managed.map(value => __long.unwrap(value): java.lang.Long)
      )(_.s3Managed)
      .optionallyWith(
        unencrypted.map(value => __long.unwrap(value): java.lang.Long)
      )(_.unencrypted)
      .optionallyWith(
        unknown.map(value => __long.unwrap(value): java.lang.Long)
      )(_.unknown)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly =
    zio.aws.macie2.model.ObjectCountByEncryptionType.wrap(buildAwsValue())
}
object ObjectCountByEncryptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ObjectCountByEncryptionType =
      zio.aws.macie2.model.ObjectCountByEncryptionType(
        customerManaged.map(value => value),
        kmsManaged.map(value => value),
        s3Managed.map(value => value),
        unencrypted.map(value => value),
        unknown.map(value => value)
      )
    def customerManaged: Option[__long]
    def kmsManaged: Option[__long]
    def s3Managed: Option[__long]
    def unencrypted: Option[__long]
    def unknown: Option[__long]
    def getCustomerManaged: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("customerManaged", customerManaged)
    def getKmsManaged: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("kmsManaged", kmsManaged)
    def getS3Managed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("s3Managed", s3Managed)
    def getUnencrypted: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unencrypted", unencrypted)
    def getUnknown: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unknown", unknown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
  ) extends zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly {
    override val customerManaged: Option[__long] = scala
      .Option(impl.customerManaged())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val kmsManaged: Option[__long] = scala
      .Option(impl.kmsManaged())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val s3Managed: Option[__long] = scala
      .Option(impl.s3Managed())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val unencrypted: Option[__long] = scala
      .Option(impl.unencrypted())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val unknown: Option[__long] = scala
      .Option(impl.unknown())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
  ): zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly = new Wrapper(
    impl
  )
}
