package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListCustomDataIdentifiersResponse(
    items: Option[Iterable[zio.aws.macie2.model.CustomDataIdentifierSummary]] =
      None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse = {
    import ListCustomDataIdentifiersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly =
    zio.aws.macie2.model.ListCustomDataIdentifiersResponse.wrap(buildAwsValue())
}
object ListCustomDataIdentifiersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListCustomDataIdentifiersResponse =
      zio.aws.macie2.model.ListCustomDataIdentifiersResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[
      List[zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly]
    ]
    def nextToken: Option[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse
  ) extends zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly {
    override val items: Option[
      List[zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.CustomDataIdentifierSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse
  ): zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly =
    new Wrapper(impl)
}
