package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListClassificationJobsResponse(
    items: Option[Iterable[zio.aws.macie2.model.JobSummary]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse = {
    import ListClassificationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly =
    zio.aws.macie2.model.ListClassificationJobsResponse.wrap(buildAwsValue())
}
object ListClassificationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListClassificationJobsResponse =
      zio.aws.macie2.model.ListClassificationJobsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.macie2.model.JobSummary.ReadOnly]]
    def nextToken: Option[__string]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.JobSummary.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
  ) extends zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly {
    override val items: Option[List[zio.aws.macie2.model.JobSummary.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.JobSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
  ): zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
