package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobScopeTerm(
    simpleScopeTerm: Option[zio.aws.macie2.model.SimpleScopeTerm] = None,
    tagScopeTerm: Option[zio.aws.macie2.model.TagScopeTerm] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobScopeTerm = {
    import JobScopeTerm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobScopeTerm
      .builder()
      .optionallyWith(simpleScopeTerm.map(value => value.buildAwsValue()))(
        _.simpleScopeTerm
      )
      .optionallyWith(tagScopeTerm.map(value => value.buildAwsValue()))(
        _.tagScopeTerm
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobScopeTerm.ReadOnly =
    zio.aws.macie2.model.JobScopeTerm.wrap(buildAwsValue())
}
object JobScopeTerm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.JobScopeTerm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobScopeTerm =
      zio.aws.macie2.model.JobScopeTerm(
        simpleScopeTerm.map(value => value.asEditable),
        tagScopeTerm.map(value => value.asEditable)
      )
    def simpleScopeTerm: Option[zio.aws.macie2.model.SimpleScopeTerm.ReadOnly]
    def tagScopeTerm: Option[zio.aws.macie2.model.TagScopeTerm.ReadOnly]
    def getSimpleScopeTerm
        : ZIO[Any, AwsError, zio.aws.macie2.model.SimpleScopeTerm.ReadOnly] =
      AwsError.unwrapOptionField("simpleScopeTerm", simpleScopeTerm)
    def getTagScopeTerm
        : ZIO[Any, AwsError, zio.aws.macie2.model.TagScopeTerm.ReadOnly] =
      AwsError.unwrapOptionField("tagScopeTerm", tagScopeTerm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobScopeTerm
  ) extends zio.aws.macie2.model.JobScopeTerm.ReadOnly {
    override val simpleScopeTerm
        : Option[zio.aws.macie2.model.SimpleScopeTerm.ReadOnly] = scala
      .Option(impl.simpleScopeTerm())
      .map(value => zio.aws.macie2.model.SimpleScopeTerm.wrap(value))
    override val tagScopeTerm
        : Option[zio.aws.macie2.model.TagScopeTerm.ReadOnly] = scala
      .Option(impl.tagScopeTerm())
      .map(value => zio.aws.macie2.model.TagScopeTerm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobScopeTerm
  ): zio.aws.macie2.model.JobScopeTerm.ReadOnly = new Wrapper(impl)
}
