package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class IpCity(name: Option[__string] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.IpCity = {
    import IpCity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpCity
      .builder()
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpCity.ReadOnly =
    zio.aws.macie2.model.IpCity.wrap(buildAwsValue())
}
object IpCity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.IpCity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpCity =
      zio.aws.macie2.model.IpCity(name.map(value => value))
    def name: Option[__string]
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpCity
  ) extends zio.aws.macie2.model.IpCity.ReadOnly {
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpCity
  ): zio.aws.macie2.model.IpCity.ReadOnly = new Wrapper(impl)
}
