package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class BatchGetCustomDataIdentifiersRequest(
    ids: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest = {
    import BatchGetCustomDataIdentifiersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BatchGetCustomDataIdentifiersRequest.ReadOnly =
    zio.aws.macie2.model.BatchGetCustomDataIdentifiersRequest
      .wrap(buildAwsValue())
}
object BatchGetCustomDataIdentifiersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BatchGetCustomDataIdentifiersRequest =
      zio.aws.macie2.model
        .BatchGetCustomDataIdentifiersRequest(ids.map(value => value))
    def ids: Option[List[__string]]
    def getIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("ids", ids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest
  ) extends zio.aws.macie2.model.BatchGetCustomDataIdentifiersRequest.ReadOnly {
    override val ids: Option[List[__string]] = scala
      .Option(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest
  ): zio.aws.macie2.model.BatchGetCustomDataIdentifiersRequest.ReadOnly =
    new Wrapper(impl)
}
