package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class AwsAccount(
    accountId: Option[__string] = None,
    principalId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AwsAccount = {
    import AwsAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AwsAccount
      .builder()
      .optionallyWith(
        accountId.map(value => __string.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        principalId.map(value => __string.unwrap(value): java.lang.String)
      )(_.principalId)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AwsAccount.ReadOnly =
    zio.aws.macie2.model.AwsAccount.wrap(buildAwsValue())
}
object AwsAccount {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.AwsAccount] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AwsAccount =
      zio.aws.macie2.model.AwsAccount(
        accountId.map(value => value),
        principalId.map(value => value)
      )
    def accountId: Option[__string]
    def principalId: Option[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AwsAccount
  ) extends zio.aws.macie2.model.AwsAccount.ReadOnly {
    override val accountId: Option[__string] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val principalId: Option[__string] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AwsAccount
  ): zio.aws.macie2.model.AwsAccount.ReadOnly = new Wrapper(impl)
}
