package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__boolean
import scala.jdk.CollectionConverters.*
final case class AccessControlList(
    allowsPublicReadAccess: Option[__boolean] = None,
    allowsPublicWriteAccess: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AccessControlList = {
    import AccessControlList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AccessControlList
      .builder()
      .optionallyWith(
        allowsPublicReadAccess.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.allowsPublicReadAccess)
      .optionallyWith(
        allowsPublicWriteAccess.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.allowsPublicWriteAccess)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AccessControlList.ReadOnly =
    zio.aws.macie2.model.AccessControlList.wrap(buildAwsValue())
}
object AccessControlList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AccessControlList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AccessControlList =
      zio.aws.macie2.model.AccessControlList(
        allowsPublicReadAccess.map(value => value),
        allowsPublicWriteAccess.map(value => value)
      )
    def allowsPublicReadAccess: Option[__boolean]
    def allowsPublicWriteAccess: Option[__boolean]
    def getAllowsPublicReadAccess: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("allowsPublicReadAccess", allowsPublicReadAccess)
    def getAllowsPublicWriteAccess: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("allowsPublicWriteAccess", allowsPublicWriteAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AccessControlList
  ) extends zio.aws.macie2.model.AccessControlList.ReadOnly {
    override val allowsPublicReadAccess: Option[__boolean] = scala
      .Option(impl.allowsPublicReadAccess())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val allowsPublicWriteAccess: Option[__boolean] = scala
      .Option(impl.allowsPublicWriteAccess())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AccessControlList
  ): zio.aws.macie2.model.AccessControlList.ReadOnly = new Wrapper(impl)
}
