package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class AcceptInvitationRequest(
    administratorAccountId: Option[__string] = None,
    invitationId: __string,
    masterAccount: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest = {
    import AcceptInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
      .builder()
      .optionallyWith(
        administratorAccountId.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.administratorAccountId)
      .invitationId(__string.unwrap(invitationId): java.lang.String)
      .optionallyWith(
        masterAccount.map(value => __string.unwrap(value): java.lang.String)
      )(_.masterAccount)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AcceptInvitationRequest.ReadOnly =
    zio.aws.macie2.model.AcceptInvitationRequest.wrap(buildAwsValue())
}
object AcceptInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AcceptInvitationRequest =
      zio.aws.macie2.model.AcceptInvitationRequest(
        administratorAccountId.map(value => value),
        invitationId,
        masterAccount.map(value => value)
      )
    def administratorAccountId: Option[__string]
    def invitationId: __string
    def masterAccount: Option[__string]
    def getAdministratorAccountId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("administratorAccountId", administratorAccountId)
    def getInvitationId: ZIO[Any, Nothing, __string] = ZIO.succeed(invitationId)
    def getMasterAccount: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("masterAccount", masterAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
  ) extends zio.aws.macie2.model.AcceptInvitationRequest.ReadOnly {
    override val administratorAccountId: Option[__string] = scala
      .Option(impl.administratorAccountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val invitationId: __string =
      zio.aws.macie2.model.primitives.__string(impl.invitationId())
    override val masterAccount: Option[__string] = scala
      .Option(impl.masterAccount())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
  ): zio.aws.macie2.model.AcceptInvitationRequest.ReadOnly = new Wrapper(impl)
}
