package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateRevealConfigurationRequest(
    configuration: zio.aws.macie2.model.RevealConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest = {
    import UpdateRevealConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
      .builder()
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateRevealConfigurationRequest.ReadOnly =
    zio.aws.macie2.model.UpdateRevealConfigurationRequest.wrap(buildAwsValue())
}
object UpdateRevealConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateRevealConfigurationRequest =
      zio.aws.macie2.model
        .UpdateRevealConfigurationRequest(configuration.asEditable)
    def configuration: zio.aws.macie2.model.RevealConfiguration.ReadOnly
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.macie2.model.RevealConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
  ) extends zio.aws.macie2.model.UpdateRevealConfigurationRequest.ReadOnly {
    override val configuration
        : zio.aws.macie2.model.RevealConfiguration.ReadOnly =
      zio.aws.macie2.model.RevealConfiguration.wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
  ): zio.aws.macie2.model.UpdateRevealConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
