package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRevealConfigurationResponse(
    configuration: Optional[zio.aws.macie2.model.RevealConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetRevealConfigurationResponse = {
    import GetRevealConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetRevealConfigurationResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.GetRevealConfigurationResponse.wrap(buildAwsValue())
}
object GetRevealConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetRevealConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetRevealConfigurationResponse =
      zio.aws.macie2.model.GetRevealConfigurationResponse(
        configuration.map(value => value.asEditable)
      )
    def configuration
        : Optional[zio.aws.macie2.model.RevealConfiguration.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.RevealConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetRevealConfigurationResponse
  ) extends zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly {
    override val configuration
        : Optional[zio.aws.macie2.model.RevealConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.macie2.model.RevealConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetRevealConfigurationResponse
  ): zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
