package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetFindingsFilterResponse(
    action: Optional[zio.aws.macie2.model.FindingsFilterAction] =
      Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria] =
      Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    position: Optional[__integer] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse = {
    import GetFindingsFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(position.map(value => value: Integer))(_.position)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly =
    zio.aws.macie2.model.GetFindingsFilterResponse.wrap(buildAwsValue())
}
object GetFindingsFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetFindingsFilterResponse =
      zio.aws.macie2.model.GetFindingsFilterResponse(
        action.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        findingCriteria.map(value => value.asEditable),
        id.map(value => value),
        name.map(value => value),
        position.map(value => value),
        tags.map(value => value)
      )
    def action: Optional[zio.aws.macie2.model.FindingsFilterAction]
    def arn: Optional[__string]
    def description: Optional[__string]
    def findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly]
    def id: Optional[__string]
    def name: Optional[__string]
    def position: Optional[__integer]
    def tags: Optional[Map[__string, __string]]
    def getAction
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingsFilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPosition: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("position", position)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
  ) extends zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly {
    override val action: Optional[zio.aws.macie2.model.FindingsFilterAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.macie2.model.FindingsFilterAction.wrap(value))
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val findingCriteria
        : Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.macie2.model.FindingCriteria.wrap(value))
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val position: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: __integer)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
  ): zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly = new Wrapper(impl)
}
