package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait AutomatedDiscoveryStatus {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus
}
object AutomatedDiscoveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus
  ): zio.aws.macie2.model.AutomatedDiscoveryStatus = value match {
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.AutomatedDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.macie2.model.AutomatedDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus.ENABLED
  }
  case object DISABLED extends zio.aws.macie2.model.AutomatedDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryStatus.DISABLED
  }
}
