package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait RevealRequestStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.RevealRequestStatus
}
object RevealRequestStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.RevealRequestStatus
  ): zio.aws.macie2.model.RevealRequestStatus = value match {
    case software.amazon.awssdk.services.macie2.model.RevealRequestStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.RevealRequestStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.macie2.model.RevealRequestStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.macie2.model.RevealRequestStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.RevealRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealRequestStatus =
      software.amazon.awssdk.services.macie2.model.RevealRequestStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.macie2.model.RevealRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealRequestStatus =
      software.amazon.awssdk.services.macie2.model.RevealRequestStatus.SUCCESS
  }
  case object PROCESSING extends zio.aws.macie2.model.RevealRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealRequestStatus =
      software.amazon.awssdk.services.macie2.model.RevealRequestStatus.PROCESSING
  }
  case object ERROR extends zio.aws.macie2.model.RevealRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealRequestStatus =
      software.amazon.awssdk.services.macie2.model.RevealRequestStatus.ERROR
  }
}
