package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __integer,
  __timestampIso8601,
  __long,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MatchingBucket(
    accountId: Optional[__string] = Optional.Absent,
    bucketName: Optional[__string] = Optional.Absent,
    classifiableObjectCount: Optional[__long] = Optional.Absent,
    classifiableSizeInBytes: Optional[__long] = Optional.Absent,
    errorCode: Optional[zio.aws.macie2.model.BucketMetadataErrorCode] =
      Optional.Absent,
    errorMessage: Optional[__string] = Optional.Absent,
    jobDetails: Optional[zio.aws.macie2.model.JobDetails] = Optional.Absent,
    lastAutomatedDiscoveryTime: Optional[__timestampIso8601] = Optional.Absent,
    objectCount: Optional[__long] = Optional.Absent,
    objectCountByEncryptionType: Optional[
      zio.aws.macie2.model.ObjectCountByEncryptionType
    ] = Optional.Absent,
    sensitivityScore: Optional[__integer] = Optional.Absent,
    sizeInBytes: Optional[__long] = Optional.Absent,
    sizeInBytesCompressed: Optional[__long] = Optional.Absent,
    unclassifiableObjectCount: Optional[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = Optional.Absent,
    unclassifiableObjectSizeInBytes: Optional[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.MatchingBucket = {
    import MatchingBucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.MatchingBucket
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        classifiableObjectCount.map(value => value: java.lang.Long)
      )(_.classifiableObjectCount)
      .optionallyWith(
        classifiableSizeInBytes.map(value => value: java.lang.Long)
      )(_.classifiableSizeInBytes)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(lastAutomatedDiscoveryTime.map(value => value: Instant))(
        _.lastAutomatedDiscoveryTime
      )
      .optionallyWith(objectCount.map(value => value: java.lang.Long))(
        _.objectCount
      )
      .optionallyWith(
        objectCountByEncryptionType.map(value => value.buildAwsValue())
      )(_.objectCountByEncryptionType)
      .optionallyWith(sensitivityScore.map(value => value: Integer))(
        _.sensitivityScore
      )
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .optionallyWith(
        sizeInBytesCompressed.map(value => value: java.lang.Long)
      )(_.sizeInBytesCompressed)
      .optionallyWith(
        unclassifiableObjectCount.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectCount)
      .optionallyWith(
        unclassifiableObjectSizeInBytes.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectSizeInBytes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.MatchingBucket.ReadOnly =
    zio.aws.macie2.model.MatchingBucket.wrap(buildAwsValue())
}
object MatchingBucket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.MatchingBucket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.MatchingBucket =
      zio.aws.macie2.model.MatchingBucket(
        accountId.map(value => value),
        bucketName.map(value => value),
        classifiableObjectCount.map(value => value),
        classifiableSizeInBytes.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        jobDetails.map(value => value.asEditable),
        lastAutomatedDiscoveryTime.map(value => value),
        objectCount.map(value => value),
        objectCountByEncryptionType.map(value => value.asEditable),
        sensitivityScore.map(value => value),
        sizeInBytes.map(value => value),
        sizeInBytesCompressed.map(value => value),
        unclassifiableObjectCount.map(value => value.asEditable),
        unclassifiableObjectSizeInBytes.map(value => value.asEditable)
      )
    def accountId: Optional[__string]
    def bucketName: Optional[__string]
    def classifiableObjectCount: Optional[__long]
    def classifiableSizeInBytes: Optional[__long]
    def errorCode: Optional[zio.aws.macie2.model.BucketMetadataErrorCode]
    def errorMessage: Optional[__string]
    def jobDetails: Optional[zio.aws.macie2.model.JobDetails.ReadOnly]
    def lastAutomatedDiscoveryTime: Optional[__timestampIso8601]
    def objectCount: Optional[__long]
    def objectCountByEncryptionType
        : Optional[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly]
    def sensitivityScore: Optional[__integer]
    def sizeInBytes: Optional[__long]
    def sizeInBytesCompressed: Optional[__long]
    def unclassifiableObjectCount
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def unclassifiableObjectSizeInBytes
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getClassifiableObjectCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableObjectCount", classifiableObjectCount)
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketMetadataErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.JobDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getLastAutomatedDiscoveryTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField(
        "lastAutomatedDiscoveryTime",
        lastAutomatedDiscoveryTime
      )
    def getObjectCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("objectCount", objectCount)
    def getObjectCountByEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectCountByEncryptionType",
      objectCountByEncryptionType
    )
    def getSensitivityScore: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("sensitivityScore", sensitivityScore)
    def getSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getSizeInBytesCompressed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytesCompressed", sizeInBytesCompressed)
    def getUnclassifiableObjectCount: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectCount",
      unclassifiableObjectCount
    )
    def getUnclassifiableObjectSizeInBytes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectSizeInBytes",
      unclassifiableObjectSizeInBytes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.MatchingBucket
  ) extends zio.aws.macie2.model.MatchingBucket.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val bucketName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: __string)
    override val classifiableObjectCount: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableObjectCount())
        .map(value => value: __long)
    override val classifiableSizeInBytes: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableSizeInBytes())
        .map(value => value: __long)
    override val errorCode
        : Optional[zio.aws.macie2.model.BucketMetadataErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.macie2.model.BucketMetadataErrorCode.wrap(value))
    override val errorMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: __string)
    override val jobDetails
        : Optional[zio.aws.macie2.model.JobDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value => zio.aws.macie2.model.JobDetails.wrap(value))
    override val lastAutomatedDiscoveryTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAutomatedDiscoveryTime())
        .map(value => value: __timestampIso8601)
    override val objectCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.objectCount())
      .map(value => value: __long)
    override val objectCountByEncryptionType
        : Optional[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectCountByEncryptionType())
        .map(value =>
          zio.aws.macie2.model.ObjectCountByEncryptionType.wrap(value)
        )
    override val sensitivityScore: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitivityScore())
      .map(value => value: __integer)
    override val sizeInBytes: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytes())
      .map(value => value: __long)
    override val sizeInBytesCompressed: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytesCompressed())
      .map(value => value: __long)
    override val unclassifiableObjectCount
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unclassifiableObjectCount())
        .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val unclassifiableObjectSizeInBytes
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unclassifiableObjectSizeInBytes())
        .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.MatchingBucket
  ): zio.aws.macie2.model.MatchingBucket.ReadOnly = new Wrapper(impl)
}
