package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  __stringMin1Max128Pattern,
  __string,
  __stringMin1Max512PatternSS
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAllowListRequest(
    criteria: zio.aws.macie2.model.AllowListCriteria,
    description: Optional[__stringMin1Max512PatternSS] = Optional.Absent,
    id: __string,
    name: __stringMin1Max128Pattern
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateAllowListRequest = {
    import UpdateAllowListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateAllowListRequest
      .builder()
      .criteria(criteria.buildAwsValue())
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .id(id: java.lang.String)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UpdateAllowListRequest.ReadOnly =
    zio.aws.macie2.model.UpdateAllowListRequest.wrap(buildAwsValue())
}
object UpdateAllowListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateAllowListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateAllowListRequest =
      zio.aws.macie2.model.UpdateAllowListRequest(
        criteria.asEditable,
        description.map(value => value),
        id,
        name
      )
    def criteria: zio.aws.macie2.model.AllowListCriteria.ReadOnly
    def description: Optional[__stringMin1Max512PatternSS]
    def id: __string
    def name: __stringMin1Max128Pattern
    def getCriteria
        : ZIO[Any, Nothing, zio.aws.macie2.model.AllowListCriteria.ReadOnly] =
      ZIO.succeed(criteria)
    def getDescription: ZIO[Any, AwsError, __stringMin1Max512PatternSS] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, __stringMin1Max128Pattern] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateAllowListRequest
  ) extends zio.aws.macie2.model.UpdateAllowListRequest.ReadOnly {
    override val criteria: zio.aws.macie2.model.AllowListCriteria.ReadOnly =
      zio.aws.macie2.model.AllowListCriteria.wrap(impl.criteria())
    override val description: Optional[__stringMin1Max512PatternSS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin1Max512PatternSS)
    override val id: __string = impl.id(): __string
    override val name: __stringMin1Max128Pattern =
      impl.name(): __stringMin1Max128Pattern
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateAllowListRequest
  ): zio.aws.macie2.model.UpdateAllowListRequest.ReadOnly = new Wrapper(impl)
}
