package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SimpleScopeTerm(
    comparator: Optional[zio.aws.macie2.model.JobComparator] = Optional.Absent,
    key: Optional[zio.aws.macie2.model.ScopeFilterKey] = Optional.Absent,
    values: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SimpleScopeTerm = {
    import SimpleScopeTerm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SimpleScopeTerm
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SimpleScopeTerm.ReadOnly =
    zio.aws.macie2.model.SimpleScopeTerm.wrap(buildAwsValue())
}
object SimpleScopeTerm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SimpleScopeTerm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SimpleScopeTerm =
      zio.aws.macie2.model.SimpleScopeTerm(
        comparator.map(value => value),
        key.map(value => value),
        values.map(value => value)
      )
    def comparator: Optional[zio.aws.macie2.model.JobComparator]
    def key: Optional[zio.aws.macie2.model.ScopeFilterKey]
    def values: Optional[List[__string]]
    def getComparator: ZIO[Any, AwsError, zio.aws.macie2.model.JobComparator] =
      AwsError.unwrapOptionField("comparator", comparator)
    def getKey: ZIO[Any, AwsError, zio.aws.macie2.model.ScopeFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SimpleScopeTerm
  ) extends zio.aws.macie2.model.SimpleScopeTerm.ReadOnly {
    override val comparator: Optional[zio.aws.macie2.model.JobComparator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparator())
        .map(value => zio.aws.macie2.model.JobComparator.wrap(value))
    override val key: Optional[zio.aws.macie2.model.ScopeFilterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value => zio.aws.macie2.model.ScopeFilterKey.wrap(value))
    override val values: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SimpleScopeTerm
  ): zio.aws.macie2.model.SimpleScopeTerm.ReadOnly = new Wrapper(impl)
}
