package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __stringMin1Max512PatternSS,
  __stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922,
  __timestampIso8601,
  __stringMin1Max128Pattern,
  __stringMin22Max22PatternAZ0922
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AllowListSummary(
    arn: Optional[
      __stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922
    ] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__stringMin1Max512PatternSS] = Optional.Absent,
    id: Optional[__stringMin22Max22PatternAZ0922] = Optional.Absent,
    name: Optional[__stringMin1Max128Pattern] = Optional.Absent,
    updatedAt: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AllowListSummary = {
    import AllowListSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AllowListSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(updatedAt.map(value => value: Instant))(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AllowListSummary.ReadOnly =
    zio.aws.macie2.model.AllowListSummary.wrap(buildAwsValue())
}
object AllowListSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AllowListSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AllowListSummary =
      zio.aws.macie2.model.AllowListSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value),
        updatedAt.map(value => value)
      )
    def arn: Optional[
      __stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922
    ]
    def createdAt: Optional[__timestampIso8601]
    def description: Optional[__stringMin1Max512PatternSS]
    def id: Optional[__stringMin22Max22PatternAZ0922]
    def name: Optional[__stringMin1Max128Pattern]
    def updatedAt: Optional[__timestampIso8601]
    def getArn: ZIO[
      Any,
      AwsError,
      __stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922
    ] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, __stringMin1Max512PatternSS] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __stringMin22Max22PatternAZ0922] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __stringMin1Max128Pattern] =
      AwsError.unwrapOptionField("name", name)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AllowListSummary
  ) extends zio.aws.macie2.model.AllowListSummary.ReadOnly {
    override val arn: Optional[
      __stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        value: __stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922
      )
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val description: Optional[__stringMin1Max512PatternSS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin1Max512PatternSS)
    override val id: Optional[__stringMin22Max22PatternAZ0922] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value => value: __stringMin22Max22PatternAZ0922)
    override val name: Optional[__stringMin1Max128Pattern] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => value: __stringMin1Max128Pattern)
    override val updatedAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AllowListSummary
  ): zio.aws.macie2.model.AllowListSummary.ReadOnly = new Wrapper(impl)
}
