package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__boolean
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccessControlList(
    allowsPublicReadAccess: Optional[__boolean] = Optional.Absent,
    allowsPublicWriteAccess: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AccessControlList = {
    import AccessControlList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AccessControlList
      .builder()
      .optionallyWith(
        allowsPublicReadAccess.map(value => value: java.lang.Boolean)
      )(_.allowsPublicReadAccess)
      .optionallyWith(
        allowsPublicWriteAccess.map(value => value: java.lang.Boolean)
      )(_.allowsPublicWriteAccess)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AccessControlList.ReadOnly =
    zio.aws.macie2.model.AccessControlList.wrap(buildAwsValue())
}
object AccessControlList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AccessControlList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AccessControlList =
      zio.aws.macie2.model.AccessControlList(
        allowsPublicReadAccess.map(value => value),
        allowsPublicWriteAccess.map(value => value)
      )
    def allowsPublicReadAccess: Optional[__boolean]
    def allowsPublicWriteAccess: Optional[__boolean]
    def getAllowsPublicReadAccess: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("allowsPublicReadAccess", allowsPublicReadAccess)
    def getAllowsPublicWriteAccess: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("allowsPublicWriteAccess", allowsPublicWriteAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AccessControlList
  ) extends zio.aws.macie2.model.AccessControlList.ReadOnly {
    override val allowsPublicReadAccess: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsPublicReadAccess())
        .map(value => value: __boolean)
    override val allowsPublicWriteAccess: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsPublicWriteAccess())
        .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AccessControlList
  ): zio.aws.macie2.model.AccessControlList.ReadOnly = new Wrapper(impl)
}
