package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Severity(
    description: Optional[zio.aws.macie2.model.SeverityDescription] =
      Optional.Absent,
    score: Optional[__long] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Severity = {
    import Severity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Severity
      .builder()
      .optionallyWith(description.map(value => value.unwrap))(_.description)
      .optionallyWith(score.map(value => value: java.lang.Long))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Severity.ReadOnly =
    zio.aws.macie2.model.Severity.wrap(buildAwsValue())
}
object Severity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Severity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Severity = zio.aws.macie2.model
      .Severity(description.map(value => value), score.map(value => value))
    def description: Optional[zio.aws.macie2.model.SeverityDescription]
    def score: Optional[__long]
    def getDescription
        : ZIO[Any, AwsError, zio.aws.macie2.model.SeverityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getScore: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Severity
  ) extends zio.aws.macie2.model.Severity.ReadOnly {
    override val description
        : Optional[zio.aws.macie2.model.SeverityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.macie2.model.SeverityDescription.wrap(value))
    override val score: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Severity
  ): zio.aws.macie2.model.Severity.ReadOnly = new Wrapper(impl)
}
