package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpOwner(
    asn: Optional[__string] = Optional.Absent,
    asnOrg: Optional[__string] = Optional.Absent,
    isp: Optional[__string] = Optional.Absent,
    org: Optional[__string] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.IpOwner = {
    import IpOwner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpOwner
      .builder()
      .optionallyWith(asn.map(value => value: java.lang.String))(_.asn)
      .optionallyWith(asnOrg.map(value => value: java.lang.String))(_.asnOrg)
      .optionallyWith(isp.map(value => value: java.lang.String))(_.isp)
      .optionallyWith(org.map(value => value: java.lang.String))(_.org)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpOwner.ReadOnly =
    zio.aws.macie2.model.IpOwner.wrap(buildAwsValue())
}
object IpOwner {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.IpOwner] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpOwner = zio.aws.macie2.model.IpOwner(
      asn.map(value => value),
      asnOrg.map(value => value),
      isp.map(value => value),
      org.map(value => value)
    )
    def asn: Optional[__string]
    def asnOrg: Optional[__string]
    def isp: Optional[__string]
    def org: Optional[__string]
    def getAsn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("asn", asn)
    def getAsnOrg: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("asnOrg", asnOrg)
    def getIsp: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("isp", isp)
    def getOrg: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("org", org)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpOwner
  ) extends zio.aws.macie2.model.IpOwner.ReadOnly {
    override val asn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => value: __string)
    override val asnOrg: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.asnOrg())
      .map(value => value: __string)
    override val isp: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.isp())
      .map(value => value: __string)
    override val org: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.org())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpOwner
  ): zio.aws.macie2.model.IpOwner.ReadOnly = new Wrapper(impl)
}
