package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  SensitivityInspectionTemplateId,
  Timestamp,
  ClassificationScopeId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetAutomatedDiscoveryConfigurationResponse(
    classificationScopeId: Optional[ClassificationScopeId] = Optional.Absent,
    disabledAt: Optional[Timestamp] = Optional.Absent,
    firstEnabledAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    sensitivityInspectionTemplateId: Optional[SensitivityInspectionTemplateId] =
      Optional.Absent,
    status: Optional[zio.aws.macie2.model.AutomatedDiscoveryStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationResponse = {
    import GetAutomatedDiscoveryConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationResponse
      .builder()
      .optionallyWith(
        classificationScopeId.map(value =>
          ClassificationScopeId.unwrap(value): java.lang.String
        )
      )(_.classificationScopeId)
      .optionallyWith(
        disabledAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.disabledAt)
      .optionallyWith(
        firstEnabledAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.firstEnabledAt)
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        sensitivityInspectionTemplateId.map(value =>
          SensitivityInspectionTemplateId.unwrap(value): java.lang.String
        )
      )(_.sensitivityInspectionTemplateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse
      .wrap(buildAwsValue())
}
object GetAutomatedDiscoveryConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse =
      zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse(
        classificationScopeId.map(value => value),
        disabledAt.map(value => value),
        firstEnabledAt.map(value => value),
        lastUpdatedAt.map(value => value),
        sensitivityInspectionTemplateId.map(value => value),
        status.map(value => value)
      )
    def classificationScopeId: Optional[ClassificationScopeId]
    def disabledAt: Optional[Timestamp]
    def firstEnabledAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def sensitivityInspectionTemplateId
        : Optional[SensitivityInspectionTemplateId]
    def status: Optional[zio.aws.macie2.model.AutomatedDiscoveryStatus]
    def getClassificationScopeId: ZIO[Any, AwsError, ClassificationScopeId] =
      AwsError.unwrapOptionField("classificationScopeId", classificationScopeId)
    def getDisabledAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("disabledAt", disabledAt)
    def getFirstEnabledAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("firstEnabledAt", firstEnabledAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getSensitivityInspectionTemplateId
        : ZIO[Any, AwsError, SensitivityInspectionTemplateId] =
      AwsError.unwrapOptionField(
        "sensitivityInspectionTemplateId",
        sensitivityInspectionTemplateId
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.AutomatedDiscoveryStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationResponse
  ) extends zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse.ReadOnly {
    override val classificationScopeId: Optional[ClassificationScopeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classificationScopeId())
        .map(value =>
          zio.aws.macie2.model.primitives.ClassificationScopeId(value)
        )
    override val disabledAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.disabledAt())
      .map(value => zio.aws.macie2.model.primitives.Timestamp(value))
    override val firstEnabledAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.firstEnabledAt())
      .map(value => zio.aws.macie2.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.macie2.model.primitives.Timestamp(value))
    override val sensitivityInspectionTemplateId
        : Optional[SensitivityInspectionTemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitivityInspectionTemplateId())
      .map(value =>
        zio.aws.macie2.model.primitives.SensitivityInspectionTemplateId(value)
      )
    override val status
        : Optional[zio.aws.macie2.model.AutomatedDiscoveryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.macie2.model.AutomatedDiscoveryStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationResponse
  ): zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
