package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __long,
  __boolean,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class S3Object(
    bucketArn: Optional[__string] = Optional.Absent,
    eTag: Optional[__string] = Optional.Absent,
    extension: Optional[__string] = Optional.Absent,
    key: Optional[__string] = Optional.Absent,
    lastModified: Optional[__timestampIso8601] = Optional.Absent,
    path: Optional[__string] = Optional.Absent,
    publicAccess: Optional[__boolean] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.macie2.model.ServerSideEncryption] =
      Optional.Absent,
    size: Optional[__long] = Optional.Absent,
    storageClass: Optional[zio.aws.macie2.model.StorageClass] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.macie2.model.KeyValuePair]] =
      Optional.Absent,
    versionId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3Object
      .builder()
      .optionallyWith(bucketArn.map(value => value: java.lang.String))(
        _.bucketArn
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(extension.map(value => value: java.lang.String))(
        _.extension
      )
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(publicAccess.map(value => value: java.lang.Boolean))(
        _.publicAccess
      )
      .optionallyWith(serverSideEncryption.map(value => value.buildAwsValue()))(
        _.serverSideEncryption
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3Object.ReadOnly =
    zio.aws.macie2.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.S3Object] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3Object =
      zio.aws.macie2.model.S3Object(
        bucketArn.map(value => value),
        eTag.map(value => value),
        extension.map(value => value),
        key.map(value => value),
        lastModified.map(value => value),
        path.map(value => value),
        publicAccess.map(value => value),
        serverSideEncryption.map(value => value.asEditable),
        size.map(value => value),
        storageClass.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        versionId.map(value => value)
      )
    def bucketArn: Optional[__string]
    def eTag: Optional[__string]
    def extension: Optional[__string]
    def key: Optional[__string]
    def lastModified: Optional[__timestampIso8601]
    def path: Optional[__string]
    def publicAccess: Optional[__boolean]
    def serverSideEncryption
        : Optional[zio.aws.macie2.model.ServerSideEncryption.ReadOnly]
    def size: Optional[__long]
    def storageClass: Optional[zio.aws.macie2.model.StorageClass]
    def tags: Optional[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]]
    def versionId: Optional[__string]
    def getBucketArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getETag: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getExtension: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("extension", extension)
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getLastModified: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getPath: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("path", path)
    def getPublicAccess: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSize: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("size", size)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.macie2.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3Object
  ) extends zio.aws.macie2.model.S3Object.ReadOnly {
    override val bucketArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketArn())
      .map(value => value: __string)
    override val eTag: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: __string)
    override val extension: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.extension())
      .map(value => value: __string)
    override val key: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: __string)
    override val lastModified: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModified())
        .map(value => value: __timestampIso8601)
    override val path: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: __string)
    override val publicAccess: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccess())
      .map(value => value: __boolean)
    override val serverSideEncryption
        : Optional[zio.aws.macie2.model.ServerSideEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.macie2.model.ServerSideEncryption.wrap(value))
    override val size: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: __long)
    override val storageClass: Optional[zio.aws.macie2.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.macie2.model.StorageClass.wrap(value))
    override val tags
        : Optional[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val versionId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3Object
  ): zio.aws.macie2.model.S3Object.ReadOnly = new Wrapper(impl)
}
