package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionContext(
    attributes: Optional[zio.aws.macie2.model.SessionContextAttributes] =
      Optional.Absent,
    sessionIssuer: Optional[zio.aws.macie2.model.SessionIssuer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SessionContext = {
    import SessionContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SessionContext
      .builder()
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .optionallyWith(sessionIssuer.map(value => value.buildAwsValue()))(
        _.sessionIssuer
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SessionContext.ReadOnly =
    zio.aws.macie2.model.SessionContext.wrap(buildAwsValue())
}
object SessionContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SessionContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SessionContext =
      zio.aws.macie2.model.SessionContext(
        attributes.map(value => value.asEditable),
        sessionIssuer.map(value => value.asEditable)
      )
    def attributes
        : Optional[zio.aws.macie2.model.SessionContextAttributes.ReadOnly]
    def sessionIssuer: Optional[zio.aws.macie2.model.SessionIssuer.ReadOnly]
    def getAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SessionContextAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("attributes", attributes)
    def getSessionIssuer
        : ZIO[Any, AwsError, zio.aws.macie2.model.SessionIssuer.ReadOnly] =
      AwsError.unwrapOptionField("sessionIssuer", sessionIssuer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SessionContext
  ) extends zio.aws.macie2.model.SessionContext.ReadOnly {
    override val attributes
        : Optional[zio.aws.macie2.model.SessionContextAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value => zio.aws.macie2.model.SessionContextAttributes.wrap(value))
    override val sessionIssuer
        : Optional[zio.aws.macie2.model.SessionIssuer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionIssuer())
        .map(value => zio.aws.macie2.model.SessionIssuer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SessionContext
  ): zio.aws.macie2.model.SessionContext.ReadOnly = new Wrapper(impl)
}
