package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __boolean,
  __long,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class BucketMetadata(
    accountId: Optional[__string] = Optional.Absent,
    allowsUnencryptedObjectUploads: Optional[
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = Optional.Absent,
    bucketArn: Optional[__string] = Optional.Absent,
    bucketCreatedAt: Optional[__timestampIso8601] = Optional.Absent,
    bucketName: Optional[__string] = Optional.Absent,
    classifiableObjectCount: Optional[__long] = Optional.Absent,
    classifiableSizeInBytes: Optional[__long] = Optional.Absent,
    errorCode: Optional[zio.aws.macie2.model.BucketMetadataErrorCode] =
      Optional.Absent,
    errorMessage: Optional[__string] = Optional.Absent,
    jobDetails: Optional[zio.aws.macie2.model.JobDetails] = Optional.Absent,
    lastUpdated: Optional[__timestampIso8601] = Optional.Absent,
    objectCount: Optional[__long] = Optional.Absent,
    objectCountByEncryptionType: Optional[
      zio.aws.macie2.model.ObjectCountByEncryptionType
    ] = Optional.Absent,
    publicAccess: Optional[zio.aws.macie2.model.BucketPublicAccess] =
      Optional.Absent,
    region: Optional[__string] = Optional.Absent,
    replicationDetails: Optional[zio.aws.macie2.model.ReplicationDetails] =
      Optional.Absent,
    serverSideEncryption: Optional[
      zio.aws.macie2.model.BucketServerSideEncryption
    ] = Optional.Absent,
    sharedAccess: Optional[zio.aws.macie2.model.SharedAccess] = Optional.Absent,
    sizeInBytes: Optional[__long] = Optional.Absent,
    sizeInBytesCompressed: Optional[__long] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.macie2.model.KeyValuePair]] =
      Optional.Absent,
    unclassifiableObjectCount: Optional[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = Optional.Absent,
    unclassifiableObjectSizeInBytes: Optional[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = Optional.Absent,
    versioning: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketMetadata = {
    import BucketMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketMetadata
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        allowsUnencryptedObjectUploads.map(value => value.unwrap)
      )(_.allowsUnencryptedObjectUploads)
      .optionallyWith(bucketArn.map(value => value: java.lang.String))(
        _.bucketArn
      )
      .optionallyWith(bucketCreatedAt.map(value => value: Instant))(
        _.bucketCreatedAt
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        classifiableObjectCount.map(value => value: java.lang.Long)
      )(_.classifiableObjectCount)
      .optionallyWith(
        classifiableSizeInBytes.map(value => value: java.lang.Long)
      )(_.classifiableSizeInBytes)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(lastUpdated.map(value => value: Instant))(_.lastUpdated)
      .optionallyWith(objectCount.map(value => value: java.lang.Long))(
        _.objectCount
      )
      .optionallyWith(
        objectCountByEncryptionType.map(value => value.buildAwsValue())
      )(_.objectCountByEncryptionType)
      .optionallyWith(publicAccess.map(value => value.buildAwsValue()))(
        _.publicAccess
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(replicationDetails.map(value => value.buildAwsValue()))(
        _.replicationDetails
      )
      .optionallyWith(serverSideEncryption.map(value => value.buildAwsValue()))(
        _.serverSideEncryption
      )
      .optionallyWith(sharedAccess.map(value => value.unwrap))(_.sharedAccess)
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .optionallyWith(
        sizeInBytesCompressed.map(value => value: java.lang.Long)
      )(_.sizeInBytesCompressed)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        unclassifiableObjectCount.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectCount)
      .optionallyWith(
        unclassifiableObjectSizeInBytes.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectSizeInBytes)
      .optionallyWith(versioning.map(value => value: java.lang.Boolean))(
        _.versioning
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketMetadata.ReadOnly =
    zio.aws.macie2.model.BucketMetadata.wrap(buildAwsValue())
}
object BucketMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketMetadata =
      zio.aws.macie2.model.BucketMetadata(
        accountId.map(value => value),
        allowsUnencryptedObjectUploads.map(value => value),
        bucketArn.map(value => value),
        bucketCreatedAt.map(value => value),
        bucketName.map(value => value),
        classifiableObjectCount.map(value => value),
        classifiableSizeInBytes.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        jobDetails.map(value => value.asEditable),
        lastUpdated.map(value => value),
        objectCount.map(value => value),
        objectCountByEncryptionType.map(value => value.asEditable),
        publicAccess.map(value => value.asEditable),
        region.map(value => value),
        replicationDetails.map(value => value.asEditable),
        serverSideEncryption.map(value => value.asEditable),
        sharedAccess.map(value => value),
        sizeInBytes.map(value => value),
        sizeInBytesCompressed.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unclassifiableObjectCount.map(value => value.asEditable),
        unclassifiableObjectSizeInBytes.map(value => value.asEditable),
        versioning.map(value => value)
      )
    def accountId: Optional[__string]
    def allowsUnencryptedObjectUploads
        : Optional[zio.aws.macie2.model.AllowsUnencryptedObjectUploads]
    def bucketArn: Optional[__string]
    def bucketCreatedAt: Optional[__timestampIso8601]
    def bucketName: Optional[__string]
    def classifiableObjectCount: Optional[__long]
    def classifiableSizeInBytes: Optional[__long]
    def errorCode: Optional[zio.aws.macie2.model.BucketMetadataErrorCode]
    def errorMessage: Optional[__string]
    def jobDetails: Optional[zio.aws.macie2.model.JobDetails.ReadOnly]
    def lastUpdated: Optional[__timestampIso8601]
    def objectCount: Optional[__long]
    def objectCountByEncryptionType
        : Optional[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly]
    def publicAccess: Optional[zio.aws.macie2.model.BucketPublicAccess.ReadOnly]
    def region: Optional[__string]
    def replicationDetails
        : Optional[zio.aws.macie2.model.ReplicationDetails.ReadOnly]
    def serverSideEncryption
        : Optional[zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly]
    def sharedAccess: Optional[zio.aws.macie2.model.SharedAccess]
    def sizeInBytes: Optional[__long]
    def sizeInBytesCompressed: Optional[__long]
    def tags: Optional[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]]
    def unclassifiableObjectCount
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def unclassifiableObjectSizeInBytes
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def versioning: Optional[__boolean]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAllowsUnencryptedObjectUploads: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = AwsError.unwrapOptionField(
      "allowsUnencryptedObjectUploads",
      allowsUnencryptedObjectUploads
    )
    def getBucketArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getBucketCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("bucketCreatedAt", bucketCreatedAt)
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getClassifiableObjectCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableObjectCount", classifiableObjectCount)
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketMetadataErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.JobDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getLastUpdated: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getObjectCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("objectCount", objectCount)
    def getObjectCountByEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectCountByEncryptionType",
      objectCountByEncryptionType
    )
    def getPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
    def getReplicationDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.ReplicationDetails.ReadOnly] =
      AwsError.unwrapOptionField("replicationDetails", replicationDetails)
    def getServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSharedAccess: ZIO[Any, AwsError, zio.aws.macie2.model.SharedAccess] =
      AwsError.unwrapOptionField("sharedAccess", sharedAccess)
    def getSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getSizeInBytesCompressed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytesCompressed", sizeInBytesCompressed)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUnclassifiableObjectCount: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectCount",
      unclassifiableObjectCount
    )
    def getUnclassifiableObjectSizeInBytes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectSizeInBytes",
      unclassifiableObjectSizeInBytes
    )
    def getVersioning: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("versioning", versioning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketMetadata
  ) extends zio.aws.macie2.model.BucketMetadata.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val allowsUnencryptedObjectUploads
        : Optional[zio.aws.macie2.model.AllowsUnencryptedObjectUploads] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsUnencryptedObjectUploads())
        .map(value =>
          zio.aws.macie2.model.AllowsUnencryptedObjectUploads.wrap(value)
        )
    override val bucketArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketArn())
      .map(value => value: __string)
    override val bucketCreatedAt: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketCreatedAt())
        .map(value => value: __timestampIso8601)
    override val bucketName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: __string)
    override val classifiableObjectCount: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableObjectCount())
        .map(value => value: __long)
    override val classifiableSizeInBytes: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableSizeInBytes())
        .map(value => value: __long)
    override val errorCode
        : Optional[zio.aws.macie2.model.BucketMetadataErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.macie2.model.BucketMetadataErrorCode.wrap(value))
    override val errorMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: __string)
    override val jobDetails
        : Optional[zio.aws.macie2.model.JobDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value => zio.aws.macie2.model.JobDetails.wrap(value))
    override val lastUpdated: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdated())
        .map(value => value: __timestampIso8601)
    override val objectCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.objectCount())
      .map(value => value: __long)
    override val objectCountByEncryptionType
        : Optional[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectCountByEncryptionType())
        .map(value =>
          zio.aws.macie2.model.ObjectCountByEncryptionType.wrap(value)
        )
    override val publicAccess
        : Optional[zio.aws.macie2.model.BucketPublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicAccess())
        .map(value => zio.aws.macie2.model.BucketPublicAccess.wrap(value))
    override val region: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: __string)
    override val replicationDetails
        : Optional[zio.aws.macie2.model.ReplicationDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationDetails())
        .map(value => zio.aws.macie2.model.ReplicationDetails.wrap(value))
    override val serverSideEncryption
        : Optional[zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value =>
          zio.aws.macie2.model.BucketServerSideEncryption.wrap(value)
        )
    override val sharedAccess: Optional[zio.aws.macie2.model.SharedAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedAccess())
        .map(value => zio.aws.macie2.model.SharedAccess.wrap(value))
    override val sizeInBytes: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytes())
      .map(value => value: __long)
    override val sizeInBytesCompressed: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytesCompressed())
      .map(value => value: __long)
    override val tags
        : Optional[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val unclassifiableObjectCount
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unclassifiableObjectCount())
        .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val unclassifiableObjectSizeInBytes
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unclassifiableObjectSizeInBytes())
        .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val versioning: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.versioning())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketMetadata
  ): zio.aws.macie2.model.BucketMetadata.ReadOnly = new Wrapper(impl)
}
