package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFindingsFiltersResponse(
    findingsFilterListItems: Optional[
      Iterable[zio.aws.macie2.model.FindingsFilterListItem]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse = {
    import ListFindingsFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse
      .builder()
      .optionallyWith(
        findingsFilterListItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingsFilterListItems)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly =
    zio.aws.macie2.model.ListFindingsFiltersResponse.wrap(buildAwsValue())
}
object ListFindingsFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListFindingsFiltersResponse =
      zio.aws.macie2.model.ListFindingsFiltersResponse(
        findingsFilterListItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findingsFilterListItems
        : Optional[List[zio.aws.macie2.model.FindingsFilterListItem.ReadOnly]]
    def nextToken: Optional[__string]
    def getFindingsFilterListItems: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.FindingsFilterListItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingsFilterListItems",
      findingsFilterListItems
    )
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse
  ) extends zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly {
    override val findingsFilterListItems
        : Optional[List[zio.aws.macie2.model.FindingsFilterListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingsFilterListItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.FindingsFilterListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse
  ): zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly = new Wrapper(
    impl
  )
}
