package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait Currency {
  def unwrap: software.amazon.awssdk.services.macie2.model.Currency
}
object Currency {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.Currency
  ): zio.aws.macie2.model.Currency = value match {
    case software.amazon.awssdk.services.macie2.model.Currency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.Currency.USD =>
      val r = USD
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.Currency {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Currency =
      software.amazon.awssdk.services.macie2.model.Currency.UNKNOWN_TO_SDK_VERSION
  }
  case object USD extends zio.aws.macie2.model.Currency {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Currency =
      software.amazon.awssdk.services.macie2.model.Currency.USD
  }
}
