package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdminAccount(
    accountId: Optional[__string] = Optional.Absent,
    status: Optional[zio.aws.macie2.model.AdminStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AdminAccount = {
    import AdminAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AdminAccount
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AdminAccount.ReadOnly =
    zio.aws.macie2.model.AdminAccount.wrap(buildAwsValue())
}
object AdminAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AdminAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AdminAccount = zio.aws.macie2.model
      .AdminAccount(accountId.map(value => value), status.map(value => value))
    def accountId: Optional[__string]
    def status: Optional[zio.aws.macie2.model.AdminStatus]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getStatus: ZIO[Any, AwsError, zio.aws.macie2.model.AdminStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AdminAccount
  ) extends zio.aws.macie2.model.AdminAccount.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val status: Optional[zio.aws.macie2.model.AdminStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.macie2.model.AdminStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AdminAccount
  ): zio.aws.macie2.model.AdminAccount.ReadOnly = new Wrapper(impl)
}
