package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait UsageStatisticsFilterKey {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey
}
object UsageStatisticsFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey
  ): zio.aws.macie2.model.UsageStatisticsFilterKey = value match {
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.ACCOUNT_ID =>
      val r = accountId
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.SERVICE_LIMIT =>
      val r = serviceLimit
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.FREE_TRIAL_START_DATE =>
      val r = freeTrialStartDate
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.TOTAL =>
      val r = total
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.UsageStatisticsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object accountId extends zio.aws.macie2.model.UsageStatisticsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.ACCOUNT_ID
  }
  case object serviceLimit
      extends zio.aws.macie2.model.UsageStatisticsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.SERVICE_LIMIT
  }
  case object freeTrialStartDate
      extends zio.aws.macie2.model.UsageStatisticsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.FREE_TRIAL_START_DATE
  }
  case object total extends zio.aws.macie2.model.UsageStatisticsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey.TOTAL
  }
}
