package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait SharedAccess {
  def unwrap: software.amazon.awssdk.services.macie2.model.SharedAccess
}
object SharedAccess {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.SharedAccess
  ): zio.aws.macie2.model.SharedAccess = value match {
    case software.amazon.awssdk.services.macie2.model.SharedAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.SharedAccess.EXTERNAL =>
      val r = EXTERNAL
      r
    case software.amazon.awssdk.services.macie2.model.SharedAccess.INTERNAL =>
      val r = INTERNAL
      r
    case software.amazon.awssdk.services.macie2.model.SharedAccess.NOT_SHARED =>
      val r = NOT_SHARED
      r
    case software.amazon.awssdk.services.macie2.model.SharedAccess.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.SharedAccess {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SharedAccess =
      software.amazon.awssdk.services.macie2.model.SharedAccess.UNKNOWN_TO_SDK_VERSION
  }
  case object EXTERNAL extends zio.aws.macie2.model.SharedAccess {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SharedAccess =
      software.amazon.awssdk.services.macie2.model.SharedAccess.EXTERNAL
  }
  case object INTERNAL extends zio.aws.macie2.model.SharedAccess {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SharedAccess =
      software.amazon.awssdk.services.macie2.model.SharedAccess.INTERNAL
  }
  case object NOT_SHARED extends zio.aws.macie2.model.SharedAccess {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SharedAccess =
      software.amazon.awssdk.services.macie2.model.SharedAccess.NOT_SHARED
  }
  case object UNKNOWN extends zio.aws.macie2.model.SharedAccess {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SharedAccess =
      software.amazon.awssdk.services.macie2.model.SharedAccess.UNKNOWN
  }
}
