package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ObjectCountByEncryptionType(
    customerManaged: Optional[__long] = Optional.Absent,
    kmsManaged: Optional[__long] = Optional.Absent,
    s3Managed: Optional[__long] = Optional.Absent,
    unencrypted: Optional[__long] = Optional.Absent,
    unknown: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType = {
    import ObjectCountByEncryptionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
      .builder()
      .optionallyWith(customerManaged.map(value => value: java.lang.Long))(
        _.customerManaged
      )
      .optionallyWith(kmsManaged.map(value => value: java.lang.Long))(
        _.kmsManaged
      )
      .optionallyWith(s3Managed.map(value => value: java.lang.Long))(
        _.s3Managed
      )
      .optionallyWith(unencrypted.map(value => value: java.lang.Long))(
        _.unencrypted
      )
      .optionallyWith(unknown.map(value => value: java.lang.Long))(_.unknown)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly =
    zio.aws.macie2.model.ObjectCountByEncryptionType.wrap(buildAwsValue())
}
object ObjectCountByEncryptionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ObjectCountByEncryptionType =
      zio.aws.macie2.model.ObjectCountByEncryptionType(
        customerManaged.map(value => value),
        kmsManaged.map(value => value),
        s3Managed.map(value => value),
        unencrypted.map(value => value),
        unknown.map(value => value)
      )
    def customerManaged: Optional[__long]
    def kmsManaged: Optional[__long]
    def s3Managed: Optional[__long]
    def unencrypted: Optional[__long]
    def unknown: Optional[__long]
    def getCustomerManaged: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("customerManaged", customerManaged)
    def getKmsManaged: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("kmsManaged", kmsManaged)
    def getS3Managed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("s3Managed", s3Managed)
    def getUnencrypted: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unencrypted", unencrypted)
    def getUnknown: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unknown", unknown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
  ) extends zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly {
    override val customerManaged: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManaged())
      .map(value => value: __long)
    override val kmsManaged: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsManaged())
      .map(value => value: __long)
    override val s3Managed: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Managed())
      .map(value => value: __long)
    override val unencrypted: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.unencrypted())
      .map(value => value: __long)
    override val unknown: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.unknown())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType
  ): zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly = new Wrapper(
    impl
  )
}
