package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCustomDataIdentifiersRequest(
    maxResults: Optional[__integer] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest = {
    import ListCustomDataIdentifiersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListCustomDataIdentifiersRequest.ReadOnly =
    zio.aws.macie2.model.ListCustomDataIdentifiersRequest.wrap(buildAwsValue())
}
object ListCustomDataIdentifiersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListCustomDataIdentifiersRequest =
      zio.aws.macie2.model.ListCustomDataIdentifiersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[__integer]
    def nextToken: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
  ) extends zio.aws.macie2.model.ListCustomDataIdentifiersRequest.ReadOnly {
    override val maxResults: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __integer)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest
  ): zio.aws.macie2.model.ListCustomDataIdentifiersRequest.ReadOnly =
    new Wrapper(impl)
}
