package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait DataIdentifierSeverity {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity
}
object DataIdentifierSeverity {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity
  ): zio.aws.macie2.model.DataIdentifierSeverity = value match {
    case software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.DataIdentifierSeverity {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity =
      software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.macie2.model.DataIdentifierSeverity {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity =
      software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.LOW
  }
  case object MEDIUM extends zio.aws.macie2.model.DataIdentifierSeverity {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity =
      software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.MEDIUM
  }
  case object HIGH extends zio.aws.macie2.model.DataIdentifierSeverity {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity =
      software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity.HIGH
  }
}
