package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MatchingResource(
    matchingBucket: Option[zio.aws.macie2.model.MatchingBucket] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.MatchingResource = {
    import MatchingResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.MatchingResource
      .builder()
      .optionallyWith(matchingBucket.map(value => value.buildAwsValue()))(
        _.matchingBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.MatchingResource.ReadOnly =
    zio.aws.macie2.model.MatchingResource.wrap(buildAwsValue())
}
object MatchingResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.MatchingResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.MatchingResource = zio.aws.macie2.model
      .MatchingResource(matchingBucket.map(value => value.asEditable))
    def matchingBucket: Option[zio.aws.macie2.model.MatchingBucket.ReadOnly]
    def getMatchingBucket
        : ZIO[Any, AwsError, zio.aws.macie2.model.MatchingBucket.ReadOnly] =
      AwsError.unwrapOptionField("matchingBucket", matchingBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.MatchingResource
  ) extends zio.aws.macie2.model.MatchingResource.ReadOnly {
    override val matchingBucket
        : Option[zio.aws.macie2.model.MatchingBucket.ReadOnly] = scala
      .Option(impl.matchingBucket())
      .map(value => zio.aws.macie2.model.MatchingBucket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.MatchingResource
  ): zio.aws.macie2.model.MatchingResource.ReadOnly = new Wrapper(impl)
}
