package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFindingStatisticsResponse(
    countsByGroup: Option[Iterable[zio.aws.macie2.model.GroupCount]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse = {
    import GetFindingStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse
      .builder()
      .optionallyWith(
        countsByGroup.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.countsByGroup)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly =
    zio.aws.macie2.model.GetFindingStatisticsResponse.wrap(buildAwsValue())
}
object GetFindingStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetFindingStatisticsResponse =
      zio.aws.macie2.model.GetFindingStatisticsResponse(
        countsByGroup.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def countsByGroup: Option[List[zio.aws.macie2.model.GroupCount.ReadOnly]]
    def getCountsByGroup
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.GroupCount.ReadOnly]] =
      AwsError.unwrapOptionField("countsByGroup", countsByGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse
  ) extends zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly {
    override val countsByGroup
        : Option[List[zio.aws.macie2.model.GroupCount.ReadOnly]] = scala
      .Option(impl.countsByGroup())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.GroupCount.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse
  ): zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly = new Wrapper(
    impl
  )
}
